open VAR
open FUNInstr
open IMPExpr
open Op

(* Environnements à compléter *)
type global_env = { functions: (string, function_definition) Hashtbl.t }
type local_env = { dummy: unit }
    
let eval_program prog =
  let functions = Hashtbl.create 17 in
  List.iter (fun fdef -> Hashtbl.add functions fdef.name fdef) prog.text;
  
  let rec eval_function fdef params genv =
    let lenv = { dummy = () } (* à compléter ! *) in
    eval_sequence fdef.code lenv genv
    
  and eval_sequence s lenv genv =
    List.iter (fun i -> eval_instruction i lenv genv) s
      
  and eval_instruction i lenv genv = match i with
    | Exit -> exit 0
    | Print(e) ->
      let v = eval_expression e lenv genv in
      Printf.printf "%c" (char_of_int v)
    | _ -> failwith "not implemented"
  
  and eval_expression e lenv genv = match e with
    | Immediate(n) -> n
    | _ -> failwith "not implemented"

  in

  let main = Hashtbl.find functions "main" in
  eval_function main [] { functions }
