/*
 * Decompiled with CFR 0.152.
 */
package formulinf;

import formulinf.Bolide;
import formulinf.Case;
import formulinf.Vect;
import ig.Grille;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

public class Circuit
extends Grille {
    public int nbLignes;
    public int nbColonnes;
    public Case[][] terrain;
    public Bolide bolide;
    public List<Vect> historique;

    public Circuit(int nbL, int nbC, boolean[][] carte, int lD, int cD) {
        super(nbL, nbC);
        int lDCorrigee;
        this.nbLignes = nbL;
        this.nbColonnes = nbC;
        this.terrain = new Case[nbL][nbC];
        int l = 0;
        while (l < this.nbLignes) {
            int c = 0;
            while (c < this.nbColonnes) {
                Case ca;
                boolean b = l < carte.length && c < carte[l].length && carte[l][c];
                this.terrain[l][c] = ca = new Case(this, new Vect(l, c), b);
                ++c;
            }
            ++l;
        }
        int n = lD < 0 ? 0 : (lDCorrigee = lD >= nbL ? nbL - 1 : lD);
        int cDCorrigee = cD < 0 ? 0 : (cD >= nbC ? nbC - 1 : cD);
        Vect positionDepart = new Vect(lDCorrigee, cDCorrigee);
        this.bolide = new Bolide(positionDepart);
        this.getCase(positionDepart).setBackground(Color.BLUE);
        this.historique = new LinkedList<Vect>();
    }

    public boolean deplaceBolide(List<Vect> deplacements) {
        for (Vect depl : deplacements) {
            Vect positionCible = this.bolide.position.add(depl);
            if (this.getCase((Vect)positionCible).traversable) {
                this.historique.add(this.bolide.position);
                this.bolide.position = positionCible;
                continue;
            }
            this.bolide.stop();
            return false;
        }
        return true;
    }

    public void gereClic(Vect cible) {
        for (Vect pos : this.historique) {
            this.getCase(pos).setBackground(Color.WHITE);
        }
        this.historique.clear();
        this.getCase(this.bolide.position).setBackground(Color.WHITE);
        this.bolide.accelereVers(cible);
        List<Vect> deplacements = this.bolide.calculeDeplacements();
        if (this.deplaceBolide(deplacements)) {
            for (Vect pos : this.historique) {
                this.getCase(pos).setBackground(Color.GREEN);
            }
        }
        this.getCase(this.bolide.position).setBackground(Color.BLUE);
    }

    Case getCase(Vect p) {
        return this.terrain[p.x][p.y];
    }
}

