/*
 * Decompiled with CFR 0.152.
 */
package test;

import formulinf.Bolide;
import formulinf.Circuit;
import formulinf.Vect;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CircuitTest {
    Circuit c;
    Bolide b;
    boolean[][] carte;

    @Before
    public void initBolide() {
        int y;
        this.carte = new boolean[6][10];
        int x = 0;
        while (x < 6) {
            y = 0;
            while (y < 10) {
                this.carte[x][y] = false;
                ++y;
            }
            ++x;
        }
        x = 1;
        while (x < 3) {
            y = 2;
            while (y < 7) {
                this.carte[x][y] = true;
                ++y;
            }
            ++x;
        }
        this.carte[3][7] = true;
        this.carte[4][7] = true;
        this.carte[4][8] = true;
        this.c = new Circuit(6, 10, this.carte, 1, 3);
        this.c.bolide.vitesse = new Vect(1, 2);
    }

    @Test
    public void circuitSimple1() {
        Circuit c0 = new Circuit(6, 10, this.carte, 1, 3);
        Assert.assertEquals(6L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 3), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
    }

    @Test
    public void circuitSimple2() {
        Circuit c0 = new Circuit(6, 10, this.carte, 1, 1);
        Assert.assertEquals(6L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 1), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
    }

    @Test
    public void circuitDepartHorsLimites1() {
        Circuit c0 = new Circuit(6, 10, this.carte, 1, 12);
        Assert.assertEquals(6L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 9), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
    }

    @Test
    public void circuitDepartHorsLimites2() {
        Circuit c0 = new Circuit(6, 10, this.carte, 6, -3);
        Assert.assertEquals(6L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(5, 0), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
    }

    @Test
    public void circuitCarteTropGrande() {
        Circuit c0 = new Circuit(5, 8, this.carte, 1, 3);
        Assert.assertEquals(5L, c0.nbLignes);
        Assert.assertEquals(8L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 3), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
    }

    @Test
    public void circuitCarteTropPetite1() {
        Circuit c0 = new Circuit(8, 10, this.carte, 1, 3);
        Assert.assertEquals(8L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 3), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertTrue(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
        Assert.assertFalse(c0.terrain[6][4].traversable);
        Assert.assertFalse(c0.terrain[7][4].traversable);
    }

    @Test
    public void circuitCarteTropPetite2() {
        boolean[] ligne2 = new boolean[]{false, true, true};
        this.carte[2] = ligne2;
        Circuit c0 = new Circuit(6, 10, this.carte, 1, 3);
        Assert.assertEquals(6L, c0.nbLignes);
        Assert.assertEquals(10L, c0.nbColonnes);
        Assert.assertEquals(new Vect(1, 3), c0.bolide.position);
        Assert.assertEquals(Vect.ZERO, c0.bolide.vitesse);
        Assert.assertFalse(c0.terrain[0][4].traversable);
        Assert.assertTrue(c0.terrain[1][4].traversable);
        Assert.assertFalse(c0.terrain[2][4].traversable);
        Assert.assertFalse(c0.terrain[3][4].traversable);
        Assert.assertFalse(c0.terrain[4][4].traversable);
        Assert.assertFalse(c0.terrain[5][4].traversable);
    }

    @Test
    public void deplaceBolideLibre1() {
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(1, 0));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertTrue(ok);
        Assert.assertEquals(new Vect(2, 3), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 2), this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideLibre2() {
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(1, 1));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertTrue(ok);
        Assert.assertEquals(new Vect(2, 6), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 2), this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideLibre3() {
        this.c.bolide.position = new Vect(1, 5);
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(1, 1));
        deplacements.add(new Vect(1, 1));
        deplacements.add(new Vect(1, 1));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertTrue(ok);
        Assert.assertEquals(new Vect(4, 8), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 2), this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideLibre4() {
        this.c.bolide.position = new Vect(1, 1);
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(0, 1));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertTrue(ok);
        Assert.assertEquals(new Vect(1, 3), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 2), this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideCrash1() {
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(1, 0));
        deplacements.add(new Vect(1, 0));
        deplacements.add(new Vect(1, 0));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertFalse(ok);
        Assert.assertEquals(new Vect(2, 3), this.c.bolide.position);
        Assert.assertEquals(Vect.ZERO, this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideCrash2() {
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(-1, 1));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertFalse(ok);
        Assert.assertEquals(new Vect(1, 5), this.c.bolide.position);
        Assert.assertEquals(Vect.ZERO, this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideCrash3() {
        this.c.bolide.position = new Vect(1, 5);
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(1, 1));
        deplacements.add(new Vect(1, 0));
        deplacements.add(new Vect(0, 1));
        deplacements.add(new Vect(1, 1));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertFalse(ok);
        Assert.assertEquals(new Vect(2, 6), this.c.bolide.position);
        Assert.assertEquals(Vect.ZERO, this.c.bolide.vitesse);
    }

    @Test
    public void deplaceBolideCrash4() {
        this.c.bolide.position = new Vect(1, 1);
        LinkedList<Vect> deplacements = new LinkedList<Vect>();
        deplacements.add(new Vect(1, 0));
        deplacements.add(new Vect(1, 0));
        boolean ok = this.c.deplaceBolide(deplacements);
        Assert.assertFalse(ok);
        Assert.assertEquals(new Vect(1, 1), this.c.bolide.position);
        Assert.assertEquals(Vect.ZERO, this.c.bolide.vitesse);
    }

    @Test
    public void gereClic1() {
        this.c.gereClic(new Vect(1, 3));
        Assert.assertEquals(new Vect(2, 5), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 2), this.c.bolide.vitesse);
    }

    @Test
    public void gereClic2() {
        this.c.gereClic(new Vect(1, 7));
        Assert.assertEquals(new Vect(2, 6), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 3), this.c.bolide.vitesse);
    }

    @Test
    public void gereClic3() {
        this.c.gereClic(new Vect(0, 3));
        Assert.assertEquals(new Vect(1, 5), this.c.bolide.position);
        Assert.assertEquals(new Vect(0, 2), this.c.bolide.vitesse);
    }

    @Test
    public void gereClic4() {
        this.c.gereClic(new Vect(2, 0));
        Assert.assertEquals(new Vect(2, 4), this.c.bolide.position);
        Assert.assertEquals(new Vect(1, 1), this.c.bolide.vitesse);
    }

    @Test
    public void gereClic5() {
        this.c.bolide.vitesse = new Vect(0, 2);
        this.c.gereClic(new Vect(1, 6));
        Assert.assertEquals(new Vect(1, 6), this.c.bolide.position);
        Assert.assertEquals(new Vect(0, 3), this.c.bolide.vitesse);
    }

    @Test
    public void gereClic6() {
        this.c.bolide.vitesse = new Vect(0, 2);
        this.c.gereClic(new Vect(0, 4));
        Assert.assertEquals(new Vect(1, 4), this.c.bolide.position);
        Assert.assertEquals(Vect.ZERO, this.c.bolide.vitesse);
    }
}

