/*
 * Decompiled with CFR 0.152.
 */
package test;

import formulinf.Vect;
import org.junit.Assert;
import org.junit.Test;

public class VectTest {
    Vect v00 = new Vect(0, 0);
    Vect v01 = new Vect(0, 1);
    Vect v0n1 = new Vect(0, -1);
    Vect v02 = new Vect(0, 2);
    Vect v0n6 = new Vect(0, -6);
    Vect v10 = new Vect(1, 0);
    Vect v11 = new Vect(1, 1);
    Vect v1n1 = new Vect(1, -1);
    Vect v12 = new Vect(1, 2);
    Vect v13 = new Vect(1, 3);
    Vect vn10 = new Vect(-1, 0);
    Vect vn11 = new Vect(-1, 1);
    Vect vn1n1 = new Vect(-1, -1);
    Vect v20 = new Vect(2, 0);
    Vect v21 = new Vect(2, 1);
    Vect v23 = new Vect(2, 3);
    Vect v24 = new Vect(2, 4);
    Vect v25 = new Vect(2, 5);
    Vect v2n2 = new Vect(2, -2);
    Vect vn2n4 = new Vect(-2, -4);
    Vect v30 = new Vect(3, 0);
    Vect v31 = new Vect(3, 1);
    Vect v33 = new Vect(3, 3);
    Vect v3n7 = new Vect(3, -7);
    Vect vn33 = new Vect(-3, 3);
    Vect vn40 = new Vect(-4, 0);
    Vect vn5n2 = new Vect(-5, -2);

    @Test
    public void vectZero() {
        Vect v = new Vect(0, 0);
        Assert.assertEquals(0L, v.x);
        Assert.assertEquals(0L, v.y);
    }

    @Test
    public void vectPos() {
        Vect v = new Vect(2, 0);
        Assert.assertEquals(2L, v.x);
        Assert.assertEquals(0L, v.y);
    }

    @Test
    public void vectNeg() {
        Vect v = new Vect(-1, -2);
        Assert.assertEquals(-1L, v.x);
        Assert.assertEquals(-2L, v.y);
    }

    @Test
    public void nonEgaleZero() {
        boolean eg = this.v01.egale(Vect.ZERO);
        Assert.assertFalse(eg);
    }

    @Test
    public void zeroNonEgale() {
        boolean eg = Vect.ZERO.egale(this.v01);
        Assert.assertFalse(eg);
    }

    @Test
    public void egaleZero() {
        boolean eg = this.v00.egale(Vect.ZERO);
        Assert.assertTrue(eg);
    }

    @Test
    public void zeroEgale() {
        boolean eg = Vect.ZERO.egale(this.v00);
        Assert.assertTrue(eg);
    }

    @Test
    public void egaleAlias() {
        Vect v = this.v12;
        boolean eg = this.v12.egale(v);
        Assert.assertTrue(eg);
    }

    @Test
    public void egaleIdentique() {
        Vect v = new Vect(1, 2);
        boolean eg = this.v12.egale(v);
        Assert.assertTrue(eg);
    }

    @Test
    public void identiqueEgale() {
        Vect v = new Vect(1, 2);
        boolean eg = v.egale(this.v12);
        Assert.assertTrue(eg);
    }

    @Test
    public void nonEgaleTranspose() {
        boolean eg = this.v12.egale(this.v21);
        Assert.assertFalse(eg);
    }

    @Test
    public void nonEgaleDouble() {
        boolean eg = this.v12.egale(this.v24);
        Assert.assertFalse(eg);
    }

    @Test
    public void doubleNonEgale() {
        boolean eg = this.v24.egale(this.v12);
        Assert.assertFalse(eg);
    }

    @Test
    public void addZero() {
        Vect v = this.v12.add(this.v00);
        Assert.assertEquals(this.v12, v);
    }

    @Test
    public void zeroAdd() {
        Vect v = this.v00.add(this.v12);
        Assert.assertEquals(this.v12, v);
    }

    @Test
    public void addSimple1() {
        Vect v = this.v11.add(this.v12);
        Assert.assertEquals(this.v23, v);
    }

    @Test
    public void addSimple2() {
        Vect v = this.v12.add(this.v11);
        Assert.assertEquals(this.v23, v);
    }

    @Test
    public void addSimple3() {
        Vect v = this.v12.add(this.v21);
        Assert.assertEquals(this.v33, v);
    }

    @Test
    public void addNeg1() {
        Vect v = this.v12.add(this.v1n1);
        Assert.assertEquals(this.v21, v);
    }

    @Test
    public void addNeg2() {
        Vect v = this.v21.add(this.vn11);
        Assert.assertEquals(this.v12, v);
    }

    @Test
    public void addNeg3() {
        Vect v = this.v23.add(this.vn2n4);
        Assert.assertEquals(this.v0n1, v);
    }

    @Test
    public void subZero() {
        Vect v = this.v12.sub(this.v00);
        Assert.assertEquals(this.v12, v);
    }

    @Test
    public void zeroSub1() {
        Vect v = this.v00.sub(this.v01);
        Assert.assertEquals(this.v0n1, v);
    }

    @Test
    public void zeroSub2() {
        Vect v = this.v00.sub(this.v24);
        Assert.assertEquals(this.vn2n4, v);
    }

    @Test
    public void subSimple1() {
        Vect v = this.v33.sub(this.v12);
        Assert.assertEquals(this.v21, v);
    }

    @Test
    public void subSimple2() {
        Vect v = this.v12.sub(this.v11);
        Assert.assertEquals(this.v01, v);
    }

    @Test
    public void subSimple3() {
        Vect v = this.v24.sub(this.v33);
        Assert.assertEquals(this.vn11, v);
    }

    @Test
    public void subNeg1() {
        Vect v = this.v21.sub(this.v1n1);
        Assert.assertEquals(this.v12, v);
    }

    @Test
    public void subNeg2() {
        Vect v = this.v24.sub(this.vn11);
        Assert.assertEquals(this.v33, v);
    }

    @Test
    public void subNeg3() {
        Vect v = this.v00.sub(this.vn2n4);
        Assert.assertEquals(this.v24, v);
    }
}

