/*
 * Decompiled with CFR 0.152.
 */
import IG.Grille;

class Plateau
extends Grille {
    private static int taille;
    public Case[][] plateau;
    private int indiceL;
    private int indiceC;

    public Plateau(int taille) {
        super(taille, taille);
        Plateau.taille = taille;
        this.plateau = new Case[taille][taille];
        int i = 0;
        while (i < taille) {
            int j = 0;
            while (j < taille) {
                Case c;
                this.plateau[i][j] = c = new Case(this);
                this.ajouteElement(c);
                ++j;
            }
            ++i;
        }
    }

    private int compteLigne(Case[] l) {
        int nb = 0;
        Case[] caseArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Case c = caseArray[n2];
            if (c.estOccupee()) {
                ++nb;
            }
            ++n2;
        }
        return nb;
    }

    private boolean verifieLignes() {
        boolean ok = true;
        Case[][] caseArray = this.plateau;
        int n = this.plateau.length;
        int n2 = 0;
        while (n2 < n) {
            Case[] l = caseArray[n2];
            ok = ok && this.compteLigne(l) < 2;
            ++n2;
        }
        return ok;
    }

    private int compteColonne(int j) {
        int nb = 0;
        int i = 0;
        while (i < taille) {
            if (this.plateau[i][j].estOccupee()) {
                ++nb;
            }
            ++i;
        }
        return nb;
    }

    private boolean verifieColonnes() {
        boolean ok = true;
        int j = 0;
        while (j < taille) {
            ok = ok && this.compteColonne(j) < 2;
            ++j;
        }
        return ok;
    }

    private int compteDiagonale(int k) {
        int max;
        int min;
        int nb = 0;
        if (k < 0) {
            min = -k;
            max = taille;
        } else {
            min = 0;
            max = taille - k;
        }
        int i = min;
        while (i < max) {
            if (this.plateau[i][i + k].estOccupee()) {
                ++nb;
            }
            ++i;
        }
        return nb;
    }

    private boolean verifieDiagonales() {
        boolean ok = true;
        int k = 2 - taille;
        while (k < taille - 1) {
            ok = ok && this.compteDiagonale(k) < 2;
            ++k;
        }
        return ok;
    }

    private int compteAntidiagonale(int k) {
        int max;
        int min;
        int nb = 0;
        if (k < 0) {
            min = -k;
            max = taille;
        } else {
            min = 0;
            max = taille - k;
        }
        int i = min;
        while (i < max) {
            if (this.plateau[taille - 1 - i][i + k].estOccupee()) {
                ++nb;
            }
            ++i;
        }
        return nb;
    }

    private boolean verifieAntidiagonales() {
        boolean ok = true;
        int k = 2 - taille;
        while (k < taille - 1) {
            ok = ok && this.compteAntidiagonale(k) < 2;
            ++k;
        }
        return ok;
    }

    public boolean verifieConfiguration() {
        return this.verifieLignes() && this.verifieColonnes() && this.verifieDiagonales() && this.verifieAntidiagonales();
    }

    private int prochaineLigne() {
        int k = 0;
        while (k < taille && this.compteLigne(this.plateau[k]) != 0) {
            ++k;
        }
        return k;
    }

    public int getIndiceL() {
        return this.indiceL;
    }

    public int getIndiceC() {
        return this.indiceC;
    }

    public boolean verifieResolubilite() {
        if (this.verifieConfiguration()) {
            int l = this.prochaineLigne();
            if (l == taille) {
                return true;
            }
            boolean solutionTrouvee = false;
            int c = 0;
            while (c < taille && !solutionTrouvee) {
                this.plateau[l][c].occupe();
                solutionTrouvee = this.verifieResolubilite();
                this.plateau[l][c].libere();
                this.indiceC = c++;
            }
            this.indiceL = l;
            return solutionTrouvee;
        }
        return false;
    }
}

